/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CUDPSocket.cp,v 1.1 1999/10/26 02:05:03 jason Exp $
____________________________________________________________________________*/

#include "CUDPSocket.h"



CUDPSocket::CUDPSocket()
	: mConnected(false), mBound(false)
{
	OSStatus	err;
	
	// Create the endpoint
	mEndpointRef = ::OTOpenEndpoint(	::OTCreateConfiguration(kUDPName),
										0,
										0,
										&err);
	ThrowIfOTError(err);
	err = ::OTSetBlocking(mEndpointRef);
	ThrowIfOTError(err);
	err = ::OTInstallNotifier(	mEndpointRef,
								NotifyProc,
								this);
	ThrowIfOTError(err);
	err = ::OTUseSyncIdleEvents(	mEndpointRef,
									true);
	ThrowIfOTError(err);
	mSocketType = kPGPSocketTypeDatagram;
}



CUDPSocket::~CUDPSocket()
{
}



	void
CUDPSocket::Bind(
	const PGPSocketAddressInternet *	inAddress)
{
	CInternetSocket::Bind(inAddress);
	DoBind(0);
	mBound = true;
}



	void
CUDPSocket::Connect(
	const PGPSocketAddressInternet *	inAddress)
{
	mConnected = true;
	::BlockMoveData(inAddress, &mConnectAddress, 
		sizeof(PGPSocketAddressInternet));
}



	SInt32
CUDPSocket::Send(
	const void *	inBuffer,
	SInt32			inLength,
	SInt32			inFlags)
{
	SInt32	result = 0;
	
	(void) inFlags;
	
	if (mConnected) {
		result = SendTo(inBuffer, inLength, &mConnectAddress);
	} else {
		ThrowPGPError_(kPGPError_SocketsNotConnected);
	}
	
	return result;
}



	SInt32
CUDPSocket::SendTo(
	const void *						inBuffer,
	SInt32								inLength,
	const PGPSocketAddressInternet *	inAddress)
{
	OSStatus		err;
	TUnitData		theDataUnit;
	InetAddress		theAddress;
	
	// Fill out the data unit structure
	theAddress.fAddressType = AF_INET;
	theAddress.fPort = inAddress->sin_port;
	theAddress.fHost = inAddress->sin_addr.s_addr;
	theDataUnit.addr.len = sizeof(theAddress);
	theDataUnit.addr.buf = (UInt8 *) &theAddress;
	theDataUnit.opt.len = 0;
	theDataUnit.opt.buf = nil;
	theDataUnit.udata.len = inLength;
	theDataUnit.udata.buf = (UInt8 *) inBuffer;
	
	err = ::OTSndUData(		mEndpointRef,
							&theDataUnit);
	ThrowIfOTError(err);
	return inLength;
}




	SInt32
CUDPSocket::Receive(
	void *	outBuffer,
	SInt32	inLength,
	SInt32	inFlags)
{
	(void) inFlags;
	
	return ReceiveFrom(outBuffer, inLength, nil, nil);
}



	SInt32
CUDPSocket::ReceiveFrom(
	void *						outBuffer,
	SInt32						inSize,
	PGPSocketAddressInternet *	outAddress,
	SInt32 *					ioAddressLength)
{
	OSStatus		err;
	TUnitData		theDataUnit;
	InetAddress		theAddress;
	OTFlags			flags;

	// Fill out the data unit structure
	theDataUnit.addr.maxlen = sizeof(theAddress);
	theDataUnit.addr.buf = (UInt8 *) &theAddress;
	theDataUnit.opt.maxlen = 0;
	theDataUnit.opt.buf = nil;
	theDataUnit.udata.maxlen = inSize;
	theDataUnit.udata.buf = (UInt8 *) outBuffer;
	
	err = ::OTRcvUData(	mEndpointRef,
						&theDataUnit,
						&flags);
	ThrowIfOTError(err);
	if (outAddress != nil) {
		outAddress->sin_family = kPGPAddressFamilyInternet;
		outAddress->sin_port = theAddress.fPort;
		outAddress->sin_addr.s_addr = theAddress.fHost;
	}
	
	if (ioAddressLength != nil) {
		*ioAddressLength = sizeof(PGPSocketAddressInternet);
	}
	
	return theDataUnit.udata.len;
}


	void
CUDPSocket::Listen(
	SInt32	inMaxBacklog)
{
	(void) inMaxBacklog;
	
	ThrowPGPError_(kPGPError_SocketsOperationNotSupported);
}



	CSocket *
CUDPSocket::Accept(
	PGPSocketAddressInternet *	outAddress,
	SInt32 *					ioAddressLength)
{
	(void) outAddress;
	
	*ioAddressLength = 0;
	
	ThrowPGPError_(kPGPError_SocketsOperationNotSupported);
	
	return (CSocket *) kInvalidPGPSocketRef;
}



	void
CUDPSocket::GetPeerName(
	PGPSocketAddressInternet *	outName)
{
	if (mConnected) {
		*outName = mConnectAddress;
	} else {
		ThrowPGPError_(kPGPError_SocketsNotConnected);
	}
}